﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace SampleSearchWindow.Models.Search
{
    public class Searcher
    {
        private readonly List<SearchResult> list = new List<SearchResult>();
        private IQueryable<SearchResult> cachedList;

        public Searcher()
        {
            FillList();
        }

        public string SearchTerm { get; set; }

        public IQueryable<SearchResult> GetSearchResults(string searchTerm)
        {
            if (String.IsNullOrEmpty(searchTerm))
            {
                //return empty list
                return new List<SearchResult>().AsQueryable<SearchResult>();
            }
            if (searchTerm != this.SearchTerm)
            {
                this.SearchTerm = searchTerm;
                cachedList = list.Where(r => r.Description.ToString().Contains(searchTerm)).AsQueryable<SearchResult>();
            }
            return cachedList;
        }
        
        private void FillList()
        {
            //TODO:  Fill your List properly here

            for (int i = 0; i < 10000; i++)
            {
                list.Add(new SearchResult { Id = i , Description = "A" + i.ToString()});
            }

        }
    }
}