﻿using System;
using System.Linq;
using System.Web.Mvc;
using SampleSearchWindow.Models.Search;
using Kendo.Mvc.Extensions;
using Kendo.Mvc.UI;

namespace SampleSearchWindow.Controllers
{
    public class SearchWindowController : Controller
    {
        public ActionResult SearchWindow()
        {
            return PartialView();
        }

        public ActionResult Autocomplete(string term)
        {
            Searcher searcher = new Searcher();
            var searchResults = searcher.GetSearchResults(term);
            return Json(searchResults, JsonRequestBehavior.AllowGet);
        }
        
        public ActionResult GetSearchResults([DataSourceRequest]DataSourceRequest request, string term)
        {
            Searcher searcher = new Searcher();
            IQueryable<SearchResult> searchResults = searcher.GetSearchResults(term);
            DataSourceResult result = searchResults.ToDataSourceResult(request);
            return Json(result);
        }
    }
}